/**********************************************************************************************

  Copyright (C) 2010 Hilscher Gesellschaft für Systemautomation mbH.
  This program can be used by everyone according the "industrialNETworX Public License INPL".
  The license can be downloaded under <http://www.industrialNETworX.com>.

***********************************************************************************************

   Last Modification:
    @version $Id: RPCTask_Functionlist.h 7729 2010-07-08 09:40:03Z Denis $

   Description:
     DCE-FODMI includes.

   Changes:

     Date        Author        Description
     ----------------------------------------------------------------------------------
     2010-07-06  DJ            Created
**************************************************************************************/
#ifndef __FODMI_TASK_FUNCTIONLIST_H
#define __FODMI_TASK_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_FODMITASK
(
 TLR_VOID * pvRsc
);

TLR_RESULT
TaskLeave_FODMITASK
(
 TLR_VOID * pvRsc,
 TLR_VOID * pvLve
);

TLR_RESULT
TaskEnter_FODMITASK
(
 TLR_VOID * pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define FODMI_TASK_STARTUP_PARAM_VERSION3 (3)

enum
{
  FODMI_FIBER_OPTIC_IF_DMI_PINTYPE_NONE = 0,
  FODMI_FIBER_OPTIC_IF_DMI_PINTYPE_GPIO = 1,
  FODMI_FIBER_OPTIC_IF_DMI_PINTYPE_PIO  = 2,
};

enum
{
  FODMI_NETX100_HARDWARE  = 0,
  FODMI_NETX50_HARDWARE   = 1,
};


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
typedef struct FODMI_TASK_STARTUPPARAMETER_V3_Ttag    /* task startup parameter */
{
  TLR_UINT32    ulTaskIdentifier;                /* task identifier */
  TLR_UINT32    ulParamVersion;                  /* parameter version */
  TLR_UINT32    ulCyclicDiagnosis_ms;            /* cycle timer for sending diagnosis information */
  TLR_STR*      pszEddName;                      /* EDD name */
  TLR_STR*      pszLEDPort1Link;                 /* LED Port 1 Link */
  TLR_STR*      pszLEDPort1Act;                  /* LED Port 1 Act */
  TLR_STR*      pszLEDPort2Link;                 /* LED Port 2 Link */
  TLR_STR*      pszLEDPort2Act;                  /* LED Port 2 Act */
  TLR_UINT32    ulCyclicLEDActState_ms;          /* cycle timer for checking the ACT LED state */
  uint8_t       bSDA1PinIdx;                     /* mmio number */
  uint8_t       bSDA2PinIdx;                     /* mmio number */
  uint8_t       bSCLPinIdx;                      /* mmio number */
  TLR_UINT32    ulPintype;                       /* Pintype - TAG_FIBER_OPTIC_IF_DMI_PINTYPE_NONE,...*/
  uint8_t       uPin;                            /* used Pin */
  TLR_BOOLEAN   fPinInvert;                      /* if the pin shall be inverted */
  TLR_UINT32    ulEddInstance;                   /* EDD Instance to identify */
  TLR_STR*      pszPnsIfQueName;                 /* Name of PNSIF Queue to identify */
  TLR_STR*      pszPioGpioHifPioPinIdentifyName; /* Name of Pio/Gpio/HifPio to identify (depends on Pintype) */

} FODMI_TASK_STARTUPPARAMETER_V3_T;

/** @} */


/*************************************************************************************/
#endif /* #ifndef __FODMI_TASK_FUNCTIONLIST_H */
